/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.sfp;

import com.ibm.hsc.auiml.databeans.sfp.SFPSettingsBean;
import com.ibm.hsc.auiml.databeans.sfp.SFPUtil;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hwmca.common.log.ClassLogInfo;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.TaskNotifyCompleteEvent;
import com.ibm.ui.framework.TaskNotifyCompleteListener;
import com.ibm.ui.framework.TaskSelectionEvent;
import com.ibm.ui.framework.TaskSelectionListener;
import com.ibm.ui.framework.UserTaskManager;

public class SFPSettingsButtonHandler
implements TaskActionListener,
TaskSelectionListener,
TaskNotifyCompleteListener {
    private static ClassLogInfo _logInfo = new ClassLogInfo(-88, 106, "SFPSettings");
    private static final short ERRID_0021 = 33;
    private static final String TRACE_MASKD = "JSFPSETD";
    private static final String TRACE_MASKF = "JSFPSETF";
    private static final String TRACE_MASKT = "JSFPSETT";

    public void actionPerformed(TaskActionEvent taskActionEvent) {
        Trace.trace(TRACE_MASKT, "-> SFPSettingsButtonHandler.actionPerformed() " + taskActionEvent);
        String string = taskActionEvent.getElementName();
        UserTaskManager userTaskManager = null;
        try {
            userTaskManager = (UserTaskManager)taskActionEvent.getSource();
            if (string.equals("SFPCallHome.CallHomeEnableButton")) {
                SFPSettingsButtonHandler.updateSelectedStates(userTaskManager, SFPSettingsBean.ENABLED_LABEL, "SFPCallHome.CallHomeCECTable");
            } else if (string.equals("SFPCallHome.CallHomeDisableButton")) {
                SFPSettingsButtonHandler.updateSelectedStates(userTaskManager, SFPSettingsBean.DISABLED_LABEL, "SFPCallHome.CallHomeCECTable");
            } else if (string.equals("SFPLanSurveillance.SurveillanceEnableButton")) {
                SFPSettingsButtonHandler.updateSelectedStates(userTaskManager, SFPSettingsBean.ENABLED_LABEL, "SFPLanSurveillance.SurveillanceCECTable");
            } else if (string.equals("SFPLanSurveillance.SurveillanceDisableButton")) {
                SFPSettingsButtonHandler.updateSelectedStates(userTaskManager, SFPSettingsBean.DISABLED_LABEL, "SFPLanSurveillance.SurveillanceCECTable");
            } else if (string.equals("SFPLanSurveillanceNotification.EnableSurveillanceNotificationButton")) {
                SFPSettingsButtonHandler.updateSelectedStates(userTaskManager, SFPSettingsBean.ENABLED_LABEL, "SFPLanSurveillanceNotification.SurveillanceNotificationCECTable");
            } else if (string.equals("SFPLanSurveillanceNotification.DisableSurveillanceNotificationButton")) {
                SFPSettingsButtonHandler.updateSelectedStates(userTaskManager, SFPSettingsBean.DISABLED_LABEL, "SFPLanSurveillanceNotification.SurveillanceNotificationCECTable");
            } else if (string.equals("SFPCallHome.CallHomeContextMenu.CallHomeToggle")) {
                SFPSettingsButtonHandler.toggleSelectedStates(userTaskManager, "SFPCallHome.CallHomeCECTable");
            } else if (string.equals("SFPLanSurveillance.SurveillanceContextMenu.SurveillanceToggle")) {
                SFPSettingsButtonHandler.toggleSelectedStates(userTaskManager, "SFPLanSurveillance.SurveillanceCECTable");
            } else if (string.equals("SFPLanSurveillanceNotification.SurveillanceNotificationContextMenu.SurveillanceNotificationToggle")) {
                SFPSettingsButtonHandler.toggleSelectedStates(userTaskManager, "SFPLanSurveillanceNotification.SurveillanceNotificationCECTable");
            }
        }
        catch (Throwable throwable) {
            Trace.trace(TRACE_MASKD, "caught ThrowableException: " + throwable.toString());
            String string2 = string.equals("SFPCallHome.CallHomeEnableButton") ? "0023" : (string.equals("SFPCallHome.CallHomeDisableButton") ? "0023" : (string.equals("SFPLanSurveillance.SurveillanceEnableButton") ? "0023" : (string.equals("SFPLanSurveillance.SurveillanceDisableButton") ? "0023" : (string.equals("SFPLanSurveillanceNotification.EnableSurveillanceNotificationButton") ? "0023" : (string.equals("SFPLanSurveillanceNotification.DisableSurveillanceNotificationButton") ? "0023" : (string.equals("SFPCallHome.CallHomeContextMenu.CallHomeToggle") ? "0025" : (string.equals("SFPLanSurveillance.SurveillanceContextMenu.SurveillanceToggle") ? "0025" : (string.equals("SFPLanSurveillanceNotification.SurveillanceNotificationContextMenu.SurveillanceNotificationToggle") ? "0025" : "0022"))))))));
            try {
                SFPUtil.showSFPErrorWindowMessageModal(string2, HSCResourceBundleUtil.getMessage("SFPResourceBundleMessages", string2, "An error occurred when changing the state for Call Home. Can not display message " + string2), HSCResourceBundleUtil.getMessage("SFPResourceBundle", "SFP_MESSAGE_ERROR_TITLE", "Service Focal Point Error"), userTaskManager);
            }
            catch (Throwable throwable2) {
                SFPUtil.showSFPErrorWindowMessageModal("0000", "An error occurred when changing the state for Call Home. Can not display message " + string2, HSCResourceBundleUtil.getMessage("SFPResourceBundle", "SFP_MESSAGE_ERROR_TITLE", "Service Focal Point Error"), userTaskManager);
            }
            new AusMicrocodeLog(_logInfo, 33, throwable).log();
        }
        Trace.trace(TRACE_MASKT, "<- SFPSettingsButtonHandler.actionPerformed() ");
    }

    public void selectionChanged(TaskSelectionEvent taskSelectionEvent) {
        Trace.trace(TRACE_MASKT, "-> SFPSettingsButtonHandler.selectionChanged() " + taskSelectionEvent);
        UserTaskManager userTaskManager = (UserTaskManager)taskSelectionEvent.getSource();
        String string = taskSelectionEvent.getElementName();
        SFPSettingsButtonHandler.setButtonStates(userTaskManager, string);
        Trace.trace(TRACE_MASKT, "<- SFPSettingsButtonHandler.selectionChanged() ");
    }

    private static void setButtonStates(UserTaskManager userTaskManager, String string) {
        Trace.trace(TRACE_MASKT, "-> SFPSettingsButtonHandler.setButtonStates()");
        boolean bl = userTaskManager.getSelectedRows(string).length > 0;
        SFPSettingsBean sFPSettingsBean = (SFPSettingsBean)userTaskManager.getDataObjects()[0];
        boolean bl2 = bl = bl && sFPSettingsBean.hasWriteAccess();
        if (string.equals("SFPCallHome.CallHomeCECTable")) {
            Trace.trace(TRACE_MASKD, "SFPSettingsButtonHandler.setButtonStates() setting call home buttons to " + bl);
            userTaskManager.setEnabled("SFPCallHome.CallHomeEnableButton", bl);
            userTaskManager.setEnabled("SFPCallHome.CallHomeDisableButton", bl);
        } else if (string.equals("SFPLanSurveillance.SurveillanceCECTable")) {
            Trace.trace(TRACE_MASKD, "SFPSettingsButtonHandler.setButtonStates() setting surveillance buttons to " + bl);
            userTaskManager.setEnabled("SFPLanSurveillance.SurveillanceEnableButton", bl);
            userTaskManager.setEnabled("SFPLanSurveillance.SurveillanceDisableButton", bl);
        } else if (string.equals("SFPLanSurveillanceNotification.SurveillanceNotificationCECTable")) {
            Trace.trace(TRACE_MASKD, "SFPSettingsButtonHandler.setButtonStates() setting notification buttons to " + bl);
            userTaskManager.setEnabled("SFPLanSurveillanceNotification.EnableSurveillanceNotificationButton", bl);
            userTaskManager.setEnabled("SFPLanSurveillanceNotification.DisableSurveillanceNotificationButton", bl);
        }
        Trace.trace(TRACE_MASKT, "<- SFPSettingsButtonHandler.setButtonStates()");
    }

    private static void toggleSelectedStates(UserTaskManager userTaskManager, String string) {
        Trace.trace(TRACE_MASKT, "-> SFPSettingsButtonHandler.toggleSelectedStates() for table " + string);
        SFPSettingsBean sFPSettingsBean = (SFPSettingsBean)userTaskManager.getDataObjects()[0];
        if (!sFPSettingsBean.hasWriteAccess()) {
            Trace.trace(TRACE_MASKT, "<- SFPSettingsButtonHandler.toggleSelectedStates() has no write access; returning");
            return;
        }
        int[] nArray = userTaskManager.getSelectedRows(string);
        int n = nArray.length;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            Trace.trace(TRACE_MASKD, "SFPSettingsButtonHandler.toggleSelectedStates() Parsing selected index: " + n2);
            ItemDescriptor[] itemDescriptorArray = userTaskManager.getRow(string, nArray[n2]);
            if (itemDescriptorArray[1].getTitle().equals(SFPSettingsBean.UNKNOWN_LABEL)) {
                try {
                    SFPUtil.showSFPErrorWindowMessageModal("0060" + itemDescriptorArray[2].getTitle(), HSCResourceBundleUtil.getMessage("SFPResourceBundleMessages", "0060", "Can not change state from Unknown for machine " + itemDescriptorArray[2].getTitle()), HSCResourceBundleUtil.getMessage("SFPResourceBundle", "SFP_MESSAGE_ERROR_TITLE", "Service Focal Point Error"), userTaskManager);
                }
                catch (Exception exception) {
                    SFPUtil.showSFPErrorWindowMessageModal("0000", "Can not change state from Unknown for machine " + itemDescriptorArray[2].getTitle(), HSCResourceBundleUtil.getMessage("SFPResourceBundle", "SFP_MESSAGE_ERROR_TITLE", "Service Focal Point Error"), userTaskManager);
                }
            } else {
                String string2 = itemDescriptorArray[1].getTitle().equals(SFPSettingsBean.ENABLED_LABEL) ? SFPSettingsBean.DISABLED_LABEL : SFPSettingsBean.ENABLED_LABEL;
                itemDescriptorArray[1].setTitle(string2);
                userTaskManager.setRow(string, nArray[n2], itemDescriptorArray);
                bl = true;
            }
            ++n2;
        }
        if (bl) {
            SFPSettingsButtonHandler.setButtonStates(userTaskManager, string);
        }
        Trace.trace(TRACE_MASKT, "<- SFPSettingsButtonHandler.toggleSelectedStates()");
    }

    private static void updateSelectedStates(UserTaskManager userTaskManager, String string, String string2) {
        Trace.trace(TRACE_MASKT, "-> SFPSettingsButtonHandler.updateSelectedStates() to " + string + " for table " + string2);
        int[] nArray = userTaskManager.getSelectedRows(string2);
        int n = nArray.length;
        if (n == 0) {
            try {
                SFPUtil.showSFPErrorWindowMessageModal("0096", HSCResourceBundleUtil.getMessage("SFPResourceBundleMessages", "0096", "No items selected when button was pressed."), HSCResourceBundleUtil.getMessage("SFPResourceBundle", "SFP_MESSAGE_ERROR_TITLE", "Service Focal Point Error"), userTaskManager);
            }
            catch (Exception exception) {
                SFPUtil.showSFPErrorWindowMessageModal("0000", "No items selected when button was pressed.", HSCResourceBundleUtil.getMessage("SFPResourceBundle", "SFP_MESSAGE_ERROR_TITLE", "Service Focal Point Error"), userTaskManager);
            }
        } else {
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                Trace.trace(TRACE_MASKD, "Parsing selected index: " + n2);
                ItemDescriptor[] itemDescriptorArray = userTaskManager.getRow(string2, nArray[n2]);
                if (itemDescriptorArray[1].getTitle().equals(SFPSettingsBean.UNKNOWN_LABEL)) {
                    try {
                        SFPUtil.showSFPErrorWindowMessageModal("0060" + itemDescriptorArray[2].getTitle(), HSCResourceBundleUtil.getMessage("SFPResourceBundleMessages", "0060", "Can not change state from Unknown for machine " + itemDescriptorArray[2].getTitle()), HSCResourceBundleUtil.getMessage("SFPResourceBundle", "SFP_MESSAGE_ERROR_TITLE", "Service Focal Point Error"), userTaskManager);
                    }
                    catch (Exception exception) {
                        SFPUtil.showSFPErrorWindowMessageModal("0000", "Can not change state from Unknown for machine " + itemDescriptorArray[2].getTitle(), HSCResourceBundleUtil.getMessage("SFPResourceBundle", "SFP_MESSAGE_ERROR_TITLE", "Service Focal Point Error"), userTaskManager);
                    }
                } else {
                    itemDescriptorArray[1].setTitle(string);
                    userTaskManager.setRow(string2, nArray[n2], itemDescriptorArray);
                    bl = true;
                }
                ++n2;
            }
            if (bl) {
                SFPSettingsButtonHandler.setButtonStates(userTaskManager, string2);
            }
        }
        Trace.trace(TRACE_MASKT, "<- SFPSettingsButtonHandler.updateSelectedStates()");
    }

    public void taskCompleted(TaskNotifyCompleteEvent taskNotifyCompleteEvent) {
        Trace.trace(TRACE_MASKT, "-> SFPSettingsButtonHandler.taskCompleted()");
        UserTaskManager userTaskManager = (UserTaskManager)taskNotifyCompleteEvent.getSource();
        String string = taskNotifyCompleteEvent.getElementName();
        String string2 = taskNotifyCompleteEvent.getValue();
        Trace.trace(TRACE_MASKD, "SFPSettingsButtonHandler.taskCompleted() called with elementName " + string + " and value " + string2);
        SFPSettingsBean sFPSettingsBean = (SFPSettingsBean)userTaskManager.getDataObjects()[0];
        if (string.equals("SFPCallHome.CallHomeSortByComboBox")) {
            Trace.trace(TRACE_MASKD, "SFPSettingsButtonHandler.taskCompleted() sorting call home table");
            sFPSettingsBean.sortTable("SFPCallHome.CallHomeCECTable", string2);
        } else if (string.equals("SFPLanSurveillance.SurveillanceSortByComboBox")) {
            Trace.trace(TRACE_MASKD, "SFPSettingsButtonHandler.taskCompleted() sorting surveillance table");
            sFPSettingsBean.sortTable("SFPLanSurveillance.SurveillanceCECTable", string2);
        } else if (string.equals("SFPLanSurveillanceNotification.SurveillanceNotificationSortByComboBox")) {
            Trace.trace(TRACE_MASKD, "SFPSettingsButtonHandler.taskCompleted() sorting surveillance notification table");
            sFPSettingsBean.sortTable("SFPLanSurveillanceNotification.SurveillanceNotificationCECTable", string2);
        }
        Trace.trace(TRACE_MASKT, "<- SFPSettingsButtonHandler.taskCompleted()");
    }
}

